/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.RepositoryService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.net.URL;

public class RepositoryRemove
implements Action {
    @Override
    public void handleAction(Object context) throws ApplicationException {
        if (context == null) {
            return;
        }
        I18N i18n = Application.getI18n();
        String s = context.toString();
        if ("https://www.willuhn.de/products/jameica/updates".equalsIgnoreCase(s)) {
            throw new ApplicationException(i18n.tr("System-Repository darf nicht gel\u00f6scht werden"));
        }
        URL url = null;
        try {
            url = new URL(s);
        }
        catch (Exception e) {
            Logger.error((String)("invalid url: " + context), (Throwable)e);
            throw new ApplicationException(i18n.tr("Keine g\u00fcltige Repository-URL angegeben"));
        }
        String q = i18n.tr("Sind Sie sicher, da\u00df Sie diese URL l\u00f6schen m\u00f6chten?\n\n{0}", url.toString());
        try {
            if (!Application.getCallback().askUser(q)) {
                return;
            }
            RepositoryService service = (RepositoryService)Application.getBootLoader().getBootable(RepositoryService.class);
            service.removeRepository(url);
        }
        catch (OperationCanceledException service) {
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)("error while deleting url " + context), (Throwable)e);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Fehler beim L\u00f6schen der Repository-URL"), 1));
        }
    }
}

